/* 
 
 PitchShifterViewController.m:
 
 Copyright (C) 2011 Thomas Hass
 
 This file is part of Csound iOS Examples.
 
 The Csound for iOS Library is free software; you can redistribute it
 and/or modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.   
 
 Csound is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with Csound; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 02111-1307 USA
 
 */

#import "PitchShifterViewController.h"

@implementation PitchShifterViewController

- (IBAction)toggleOnOff:(UISwitch *)sender
{
	if (sender.on) {
		NSString *tempFile = [[NSBundle mainBundle] pathForResource:@"pitchshifter" ofType:@"csd"];
		
		[self.csound stopCsound];
		self.csound = [[CsoundObj alloc] init];
		[self.csound addCompletionListener:self];
		
		[self.csound addValueCacheable:mXYControl];
		
		[self.csound startCsound:tempFile];
	} else {
		[self.csound stopCsound];
	}
}

#pragma mark - CsoundObj Listener

- (void)csoundObjDidStart:(CsoundObj *)csoundObj {
}


- (void)csoundObjComplete:(CsoundObj *)csoundObj {
	[mSwitch setOn:NO animated:YES];
}

#pragma mark - Lifecycle

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
	self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
	if (self) {
		
	}
	return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	self.title = @"Pitch Shifter";
	
	[mXYControl setXValue:1.0f];
	[mXYControl setYValue:0.5f];
}

- (void)viewDidUnload
{
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    if (interfaceOrientation == UIInterfaceOrientationLandscapeLeft ||
        interfaceOrientation == UIInterfaceOrientationLandscapeRight) {
        return YES;
    } else {
        return NO;
    }
}

- (void)dealloc
{
	[mSwitch release];
	[mXYControl release];
	[super dealloc];
}

@end
